@extends('backoffice.dashboard')
@section('content')
<style>
    .btn-success-custom {
        background-color: green;
        color: white;
    }

    .btn-success-custom i { color: white; }

    .btn-orange {
        background-color: orange;
        color: white;
    }

    .btn-orange i { color: white; }
</style>

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">{{ $type->type_ar }}</h2>
                    <a class="btn btn-success font-weight-medium" href="{{ route('guides.create', $type->id_type) }}">
                        <i class="la la-plus mr-1"></i> إضافة
                    </a>
                </div>

                <div class="block-card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الترتيب</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($guides as $index => $guide)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $guide->titre_G }}</td>
                                        <td>{{ $guide->ordre }}</td>
                                        <td class="btn-group">

                                            <a class="btn btn-orange btn-sm mr-2" style="color:white;"
                                               onclick="confirmEdit('{{ route('guides.edit', $guide->id_G) }}')">
                                                <i class="la la-edit mr-1"></i> تعديل
                                            </a>

                                            <form action="{{ route('guides.destroy', $guide->id_G) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button" class="btn btn-danger btn-sm mr-2"
                                                        onclick="confirmDelete(this.closest('form'))">
                                                    <i class="la la-trash mr-1"></i> حذف
                                                </button>
                                            </form>

                                            <!--a class="btn bg-primary text-white btn-sm" href="">
                                                <i class="la la-file-text mr-1"></i> الصفحات
                                            </!--a-->

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد دلائل حاليا</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{-- si $guides est paginé --}}
                        {{ $guides->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- SweetAlert functions -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function confirmEdit(url) {
        Swal.fire({
            icon: 'question',
            title: 'هل تريد حقًا تعديل هذا الدليل؟',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-primary mx-2',
                cancelButton: 'btn btn-secondary'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            icon: 'warning',
            title: 'هل تريد حذف هذا الدليل؟',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء',
            reverseButtons: true,
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-danger mx-2',
                cancelButton: 'btn btn-secondary'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>

@endsection
